'use strict';

var ErrorCtrl = ['$rootScope', function($rootScope){
    $rootScope.__pageErrorShow__ = false;
}]

ErrorCtrl.showError = function(data){
    throw data;
}

//app.factory('$exceptionHandler', function($injector) {
//    return function(resourceExceptionData) {
//        var $rootScope = $injector.get('$rootScope');
//        $rootScope.showApiError(resourceExceptionData);
//    };
//});


app.run(function($rootScope, $location, $http){
    $rootScope.debugMode = true;
//    $rootScope.__showAdminAddDeleteGroupButton__ = true;

    if($rootScope.debugMode) {$rootScope.devAppPhp = '/app_dev.php';}
    else {$rootScope.devAppPhp = '';}


    // aktualizacja czasu pracy uzytkownika
    var random = Math.round(Math.random() * 10 + 5) * 1000;
    setInterval(function(){
        $http.post(appDev + '/spent_time')
            .success(function(data){
                if(data == 'false')
                {
                    $rootScope.$broadcast('ModalLogout:show');
                }
            })
            .error(function(data){
                $rootScope.$broadcast('ModalLogout:show');
            })
        ;
    }, random);


    $rootScope.dialogOpts = {
        backdrop: 'static',
        keyboard: false,
        backdropFade: false,
        dialogFade:true
    };

    $rootScope.__showLoading__ = 0;
    $rootScope.__showUpload__ = 0;
    $rootScope.__showSaving__ = 0;
    $rootScope.__pageErrorShow__ = false;

    $rootScope.loadingProgresBar = null;

    $rootScope.progressBarWidth = 5;
    $rootScope.progressLoadingBarWidth = 5;
    $rootScope.progressBarAnimation = true;

    $rootScope.breadcrumbCurrentPosition = '';


    $rootScope.showApiError = function(error){
        $rootScope.__pageErrorShow__ = true;
        $rootScope.__pageError__ = {
            code: error.status,
            message: error.data.message
        }
    }

    $rootScope.incLoading = function(){
//        $rootScope.$broadcast('Message:addMsg', msgLoading);
    }
    $rootScope.decLoading = function(){
//        $rootScope.$broadcast('Message:delMsg', msgLoading);
    }

    $rootScope.$on('$routeChangeStart', function(event, currRoute, prevRoute){
        angular.element('#modal-loading').modal({
            backdrop: 'static'
            ,keyboard: false
            ,show: true
        });
    });
    $rootScope.$on('$routeChangeSuccess', function(event, currRoute, prevRoute){
        angular.element('#modal-loading').modal('hide');
    });




    $rootScope.incSaving = function(progressBar){
        $rootScope.__showSaving__++;

        if($rootScope.__showSaving__ == 1)
        {
            $rootScope.$broadcast('progressBarSaving::show', true);
        }

    }
    $rootScope.decSaving = function(){
        $rootScope.__showSaving__--;

        if($rootScope.__showSaving__ == 0)
        {
            $rootScope.$broadcast('progressBarSaving::hide', true);
        }
    }

    $rootScope.isSavingProgress = function(){
        return ($rootScope.__showSaving__ > 0);
    }

    $rootScope.incUpload = function(){
        $rootScope.__showUpload__++;
    }
    $rootScope.decUpload = function(){
        $rootScope.__showUpload__--;
    }


    /*** ZMIANA LOKALIZACJI ***/
    $rootScope.__unsevedData__ = false;
    $rootScope.__nextLocationPath__ = '';
    $rootScope.goLocation = function(location){
        if($rootScope.__unsevedData__)
        {
            $rootScope.__nextLocationPath__ = location;
            $rootScope.$broadcast('changeLocationAlert::show', true);
        }
        else
        {
            $location.path(location);
        }
    }
    
    $rootScope.goLocationForce = function(){
        $rootScope.$broadcast('changeLocationAlert::hide', true);
        $location.path($rootScope.__nextLocationPath__);

        // special break for change in quiz add/edit view
        setTimeout(function(){
            $rootScope.__unsevedData__ = false;
        }, 1000);
    }
});
app.directive(directives);

app.filter('range', function() {
    return function(input, total) {
        total = parseInt(total);
        for (var i=0; i<total; i++)
            input.push(i);
        return input;
    };
});

app.filter('price', function() {
    return function(input,currency) {
        var currencyName = {'PLN':'zł','EUR':'EUR','USD':'USD'};
        if(typeof currency == "undefined"){
            currency = 'PLN';
        }
        return (parseFloat(input).toFixed(2).replace(/(\d)(?=(\d{3})+\.)/g, '$1 ').replace('.', ',')).toString() + ' ' + currencyName[currency];
    };
});

app.filter('percent', function() {
    return function(input) {
        return (parseFloat(input).toFixed(2).replace(/(\d)(?=(\d{3})+\.)/g, '$1 ').replace('.', ',')).toString() + ' %';
    };
});